<?php

use Illuminate\Support\Facades\Route;
Route::get('/clear-cache', function() {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('config:cache');
    return "Cache is cleared"; 
});

Route::get('/', 'HomeController@index');
Route::get('/home', 'HomeController@index')->name('home');
Route::get('/setting', 'HomeController@setting');
Route::post('/setting', 'HomeController@setting_update');
Route::get('/transaction', 'HomeController@transaction');
Route::get('/trading', 'HomeController@trading');
Route::get('/stacking', 'HomeController@stacking');
Route::get('/stacking-mature', 'HomeController@stacking_mature');
Route::get('/wallet', 'HomeController@wallet');
Route::post('/wallet', 'HomeController@wallet_withdraw');
Route::post('/register_', 'WelcomeController@register_save');
Route::post('/login_check', 'WelcomeController@login_check');
Route::get('/forgot_password_otp', 'WelcomeController@forgot_password_otp');
Route::post('/forgot_password_otp_check', 'WelcomeController@forgot_password_otp_check');
Route::get('/reset_password', 'WelcomeController@reset_password');
Route::post('/add-to-wallet', 'HomeController@add_to_wallet');
Route::post('/ajax-call', 'HomeController@ajax_call');
// Route::get('/plans', 'HomeController@plans');
// Route::get('/select-plan', 'HomeController@select_plan');
Auth::routes();

Route::group(['prefix'=>'admin'], function(){
    Route::get('login','Admin\LoginController@showLoginForm');
    Route::post('login','Admin\LoginController@login');
	Route::middleware([SuperAdmin::class])->group(function () {
        Route::resources([
            'products' => 'Admin\ProductController',
            'customers' => 'Admin\CustomerController',
            'transactions' => 'Admin\OrderController',
            'stacking-mature' => 'Admin\WalletController'
        ]);
    	Route::get('home','Admin\HomeController@index')->name('adminHome');
    	Route::post('logout','Admin\LoginController@logout')->name('adminLogout');
        Route::get('withdraw','Admin\OrderController@withdraw');
        Route::get('contacts','Admin\HomeController@contacts');
        Route::post('deleteContacts','Admin\HomeController@deleteContacts');
	});
});