@extends('layouts.auth')

@section('content')
	  
   <body class="vh-100">
    <div class="authincation h-100">
        <div class="container h-100">
            <div class="row justify-content-center h-100 align-items-center">
                <div class="col-md-6">
                    <div class="authincation-content">
                        <div class="row no-gutters">
                            <div class="col-xl-12">
                                <div class="auth-form">
                                    <div class="text-center mb-3">
                                       
                                    </div>
                                    <h4 class="text-center mb-4">Sign Up your account</h4>
                                    <form method="POST" action="{{ url('register_') }}">
                                        @csrf

                                        @if(Session::has('flash_error'))
                                        <span class="text-danger" role="alert">
                            <strong>{{ Session::get('flash_error') }}</strong>
                        </span>

                        @elseif(@$data['err'])
                        <span class="text-danger" role="alert">
                            <strong>{{ $data['err'] }}</strong>
                        </span>
                        @endif



                                        
                                        <div class="form-group">
                                            <label class="mb-1"><strong>Username</strong></label>
                                            <input type="text" class="form-control" placeholder="Username" name="username" value="{{@$data['username']}}" required="">
                                        </div>


                 
                                        <div class="form-group">
                                            <label class="mb-1"><strong>Email</strong></label>
                                            <input type="email" class="form-control" placeholder="hello@example.com" value="{{@$data['email']}}" name="email" required="">
                                        </div>


                                        <div class="form-group">
                                            <label class="mb-1"><strong>Phone Number</strong></label>
                                            <input type="Number" class="form-control" min=""  placeholder="1234567890" value="{{@$data['phone']}}" name="phone" required="">
                                        </div>

                                        <div class="form-group">
                                            <label class="mb-1"><strong>Referal ID</strong></label>
                                            <input type="text" class="form-control" placeholder="Referal ID" name="referal" value="{{@$_REQUEST['refer']}}" required="">
                                        </div>

                   
                                        <div class="form-group">
                                            <label class="mb-1"><strong>Password</strong></label>
                                            <input type="password" class="form-control" placeholder="Password" name="password" required="">
                                        </div>

                                        <div class="text-center mt-4">
                                            <button type="submit" class="btn btn-primary btn-block">Sign me up</button>
                                        </div>
                                    </form>
                                    <div class="new-account mt-3">
                                        <p>Already have an account? <a class="text-primary" href="{{url('login')}}">Sign
                                                In</a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection