@extends('admin.layouts.app')
@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                <h3 class="card-title">Stacking Matured</h3>
              </div>
              @if(Session::has('flash_success'))
                  <div class="alert alert-success m-2">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  {{ Session::get('flash_success') }}
                  </div>
              @endif
              <!-- /.card-header -->
              <div class="card-body">
                <div class="table-responsive">
                <table class="table table-bordered">
                  <thead>                  
                    <tr>
                      <th>ID</th> 
                      <th>User</th>
                      <th>Amount</th>
                      <th>Total</th>
                      <th>From</th>
                      <th>To</th>
                      <th>Month</th>
                      <th>Bonus</th>
                      <th>Status</th>
                      <th>Action</th>
                    </tr> 
                  </thead>
                  <tbody>
                    @foreach($data as $row)
                    <?php
$ts1 = strtotime($row->from_date);
$ts2 = strtotime($row->to_date);

$year1 = date('Y', $ts1);
$year2 = date('Y', $ts2);

$month1 = date('m', $ts1);
$month2 = date('m', $ts2);

$diff = (($year2 - $year1) * 12) + ($month2 - $month1);
                                    ?>
                    <tr>
                      <td>{{$row->id}}</td>
                      <td>
                       <a href="{{url('admin/customers')}}/{{$row->user_id}}" class="btn btn-info btn-sm">{{ @$row->user->username }}</a>
                      </td>

                      <td>{{@$row->amount}}</td>
                      <td>{{@$row->total}}</td>
                      <td>{{$row->from_date}}</td>
                      <td>{{$row->to_date}}</td>
                      <td>{{$diff}}</td>
                      <td>{{$row->bonus}}</td>
                      <td>{{@$row->remark}}</td>
                      <td><a href="{{ route('stacking-mature.edit', $row->id) }}" onclick="return confirm('Are you sure you want to approve this?');" class="btn btn-success btn-sm">Approve</a></td>
                 
                    </tr>
                    @endforeach
                  </tbody>
                </table>

                <br>
                {!! $data->links() !!}
              </div>
              </div>
              <!-- /.card-body -->
              
        </div>
        <!-- /.card -->
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
@endsection
