@extends('admin.layouts.app')
@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                <h3 class="card-title">Transactions</h3>
              </div>
              @if(Session::has('flash_success'))
                  <div class="alert alert-success m-2">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  {{ Session::get('flash_success') }}
                  </div>
              @endif
              <!-- /.card-header -->
              <div class="card-body">
                <div class="table-responsive">
                <table class="table table-bordered">
                  <thead>                  
                    <tr>
                      <th>ID</th>
                      <th>TXN</th>
                      <th>User</th>
                      <th>Amount</th>
                      <th>Date</th>
                      <th>Status</th>
                    </tr> 
                  </thead>
                  <tbody>
                    @foreach($data as $row)
                    <tr>
                      <td>{{$row->id}}</td>
                      <td>{{$row->txn_id}}</td>
                      <td>
                       <a href="{{url('admin/customers')}}/{{$row->user_id}}" class="btn btn-info btn-sm">{{ @$row->user->username }}</a>
                      </td>

                      <td>{{@$row->amount}}</td>
                      <td>{{date('d-m-Y h:i a',strtotime($row->created_at))}}</td>
                      <td>{{@$row->status}}</td>
                 
                    </tr>
                    @endforeach
                  </tbody>
                </table>

                <br>
                {!! $data->links() !!}
              </div>
              </div>
              <!-- /.card-body -->
              
        </div>
        <!-- /.card -->
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
@endsection
