@extends('admin.layouts.app')
@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                <h3 class="card-title">Customers</h3>
              </div>
              @if(Session::has('flash_success'))
                  <div class="alert alert-success">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  {{ Session::get('flash_success') }}
                  </div>
              @endif
              <!-- /.card-header -->
              <div class="card-body">
                <table class="table table-bordered">
                  <thead>                  
                    <tr>
                      <th>ID</th>
                      <th>Username</th>
                      <th>Phone</th>
                      <th>Email</th>
                      <!-- <th>Balance</th> -->
                      <th>Action</th>
                    </tr> 
                  </thead>
                  <tbody>
                    @foreach($data as $row)
                    <tr>
                      <td>{{@$row->id}}</td>
                      <td>{{@$row->username}}</td>
                      <td>{{@$row->phone}}</td>
                      <td>{{@$row->email}}</td>
                      <!-- <td><a href="" class="btn btn-success btn-sm">$100</a></td> -->
                      <td>
                        <a href="{{ route('customers.show', $row->id) }}" class="btn"><i class="fas fa-eye" style="color: black;"></i></i></a>
                      </td>
                    </tr>
                    @endforeach
                  </tbody>
                </table>
                <br>
                {!! $data->links() !!}
              </div>
              <!-- /.card-body -->
              
        </div>
        <!-- /.card -->
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
@endsection
