@extends('layouts.app')

@section('content')
    <!-- HOME SLIDER -->
    <div class="slider-wrap">
        <div class="fullwidthbanner-container" >
            <div class="fullwidthbanner">
                <ul>
                  @foreach($banners as $banner)
                  <li data-transition="parallaxtoright,parallaxtoleft" data-slotamount="7" data-masterspeed="600"  data-saveperformance="off" > 
                  <img src="{{ url('/') }}/public/uploads/images/{{$banner->image}}"  alt="banner_slider02" 
                    data-bgposition="left bottom" data-bgfit="cover" data-bgrepeat="no-repeat">
                  @endforeach
                </ul>
            </div>
        </div>
    </div>
    <!-- END HOME SLIDER -->
    
    <!-- banner-area start -->
    <div class="banner-area">
        <div class="container">
            <div class="row">
                <!-- single-banner start --> 
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="single-banner">
                        <a href="#"><img src="{{ asset('public/assets') }}/img/banner/hban1.jpg" alt="" /></a>
                    </div>
                </div>
                <!-- single-banner end -->
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="row">
                        <!-- single-banner start -->
                        <div class="col-md-6 col-sm-12">
                            <div class="single-banner">
                                <a href="#"><img src="{{ asset('public/assets') }}/img/banner/hban2.jpg" alt="" /></a>
                            </div>                          
                        </div>
                        <!-- single-banner end -->
                        <!-- single-banner start -->
                        <div class="col-md-6 col-sm-12">
                            <div class="single-banner">
                                <a href="#"><img src="{{ asset('public/assets') }}/img/banner/hban3.jpeg" alt="" /></a>
                            </div>                          
                        </div>
                        <!-- single-banner end -->
                        <!-- single-banner start -->
                        <div class="col-md-12 col-sm-12">
                            <div class="single-banner banner-top-4">
                                <a href="#"><img src="{{ asset('public/assets') }}/img/banner/hban4.jpg" alt="" /></a>
                            </div>                          
                        </div>
                        <!-- single-banner end -->
                        
                        
                    </div>
                </div>
            </div>
        </div>
    </div>  
    <!-- banner-area end -->
    <!-- features-area start -->
    <div class="features-area">
        <div class="container">
            <!-- section-heading start -->
            <div class="row">
                <div class="col-md-12">
                    <div class="section-heading">
                        <h3>SHOP BY CATEGORY</h3>
                    </div>
                </div>
            </div>
            <!-- section-heading end -->
            <div class="row">
                <div class="col-md-12">
                    <div class="features-tab">
                      <!-- Nav tabs -->
                      <ul class="nav nav-tabs justify-content-center" role="tablist">
                        @php $category_counter = 1; @endphp
                        @foreach($categories as $category)
                        @php $category_counter++; @endphp
                        <li role="presentation" @if($category_counter == 1) class="active" @endif><a @if($category_counter == 1) class="active" @endif href="#category{{$category->id}}" aria-controls="home" role="tab" data-toggle="tab">{{$category->name}}</a></li>
                        @endforeach
                      </ul> 

                      <!-- Tab panes -->
                      <div class="tab-content">
                        @php $category_counter1 = 0; @endphp
                        @foreach($categories as $category)
                        @php $category_counter1++; @endphp
                        <div role="tabpanel" class="tab-pane @if($category_counter1 == 1) active @endif" id="category{{$category->id}}">
                            <div class="row">
                                <div class="features-curosel">
                                    <!-- single-product start -->
                                    @foreach($category->products as $product)
									@php
                                
                                    foreach($brands as $brand)
                                    {

                                        $bid=$product->brand_id;
                                        if($brand->id==$bid)
                                        {
                                          $bn=$brand->name;
                                          break;
                                        }

                                    }

                                    @endphp
                   
                                    <div class="col-12">
                                        <div class="single-product">
                                            <!-- <span class="sale-text">Sale</span> -->
                                            <div class="product-img">
                                                <a href="{{url('/p')}}/{{$product->slug}}">
                                                    <img class="primary-image" src="{{ asset('public/uploads/images') }}/{{@$product->productImage->image}}" alt="{{$product->name}}" width="100%"  style="height:200px;"/>
                                                    <img class="secondary-image" src="{{ asset('public/uploads/images') }}/{{@$product->productImage->image}}" alt="{{$product->name}}" width="100%" style="height:200px;" />
                                                </a>
                                                <div class="actions">
                                                    <div class="action-buttons">
                                                        <div class="add-to-cart">
                                                            @if($product->stock_quantity > 1)
                                                            <a onclick="addToCart(<?php echo $product->id; ?>)" href="javascript:void(0)">Add to cart</a>
                                                            @else
                                                            <a href="javascript:void(0)">Out of Stock</a>
                                                            @endif
                                                        </div>
                                                        <div class="add-to-links">
                                                            <div class="add-to-wishlist">
                                                                <a href="javascript:void(0)" onclick="addToWishList(<?php echo $product->id; ?>)" data-toggle="tooltip" title="Add to Wishlist"><i class="fa fa-star"></i>
                                                                </a>
                                                            </div>                               
                                                        </div>
                                                    </div>
                                                </div>                          
                                            </div>
                                            <div class="product-content">
                                            <h2 class="product-name"><a href="{{url('/p')}}/{{$product->slug}}">{{$product->name}} - {{$product->quantity}}</a><p class="text-info">{{$bn}}</p></h2>
                                            <?php $rating = \App\Http\Controllers\WelcomeController::getProductReview($product->id); ?>
                                            <div class="pro-rating"> 
                                                @if($rating == 0)
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i>           
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i> 
                                                @endif
                                                @if($rating == 1)
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star"></i>           
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i> 
                                                @endif
                                                @if($rating == 2)
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star" style="color: #ec4445;"></i>           
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i> 
                                                @endif  
                                                @if($rating == 3)
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star" style="color: #ec4445;"></i>           
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star"></i>
                                                <i class="fa fa-star"></i> 
                                                @endif  
                                                @if($rating == 4)
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star" style="color: #ec4445;"></i>           
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star"></i> 
                                                @endif  
                                                @if($rating == 5)
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star" style="color: #ec4445;"></i>           
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star" style="color: #ec4445;"></i>
                                                <i class="fa fa-star" style="color: #ec4445;"></i> @endif   
                                            </div>
                                            <div class="price-box">
                                                <span class="new-price"> Rs {{$product->selling_price}}</span>
                                                <span class="old-price">Rs {{$product->mrp_price}}</span>
                                            </div>
                                        </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    <!-- single-product end -->
                                </div>
                            </div>
                        </div>
                        @endforeach
                      </div>
                    </div>              
                </div>
            </div>
        </div>
    </div>
    <!-- features-area end -->
    <!-- new-product-area start -->
    <div class="new-product-area">
        <div class="container">
            <!-- section-heading start -->
            <div class="row">
                <div class="col-md-12">
                    <div class="section-heading">
                        <h3>New Products</h3>
                    </div>
                </div>
            </div>
            <!-- section-heading end -->
            <div class="row">
                <div class="features-curosel">
                    <!-- single-product start -->
                    @foreach($new_products as $new_product)
					@php
                                
                                    foreach($brands as $brand)
                                    {   

                                        $bid=$new_product->brand_id;
                                        if($brand->id==$bid)
                                        {
                                          $bn=$brand->name;
                                          break;
                                        }

                                    }

                                    @endphp
                    <div class="col-12">
                        <div class="single-product">
                            <!-- <span class="sale-text">Sale</span> -->
                            <div class="product-img">
                                <a href="{{url('/p')}}/{{$new_product->slug}}">
                                    <img class="primary-image" src="{{ asset('public/uploads/images') }}/{{@$new_product->productImage->image}}" alt="{{$new_product->name}}" />
                                    <img class="secondary-image" src="{{ asset('public/uploads/images') }}/{{@$new_product->productImage->image}}" alt="{{$new_product->name}}" />
                                </a>
                                <div class="actions">
                                    <div class="action-buttons">
                                        <div class="add-to-cart">
                                            @if($new_product->stock_quantity > 1)
                                                            <a onclick="addToCart(<?php echo $product->id; ?>)" href="javascript:void(0)">Add to cart</a>
                                                            @else
                                                            <a href="javascript:void(0)">Out of Stock</a>
                                                            @endif
                                        </div>
                                        <div class="add-to-links">
                                            <div class="add-to-wishlist">
                                                <a href="javascript:void(0)" onclick="addToWishList(<?php echo $new_product->id; ?>)" data-toggle="tooltip" title="Add to Wishlist"><i class="fa fa-star"></i>
                                                </a>
                                            </div>                               
                                        </div>
                                    </div>
                                </div>                          
                            </div>
                            <div class="product-content">
                                <h2 class="product-name"><a href="{{url('/p')}}/{{$new_product->slug}}">{{$new_product->name}} - {{$new_product->quantity}}</a><p class="text-info">{{$bn}}</p></h2>
                                <?php $rating = \App\Http\Controllers\WelcomeController::getProductReview($new_product->id); ?>
                                <div class="pro-rating"> 
                                    @if($rating == 0)
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>           
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i> 
                                    @endif
                                    @if($rating == 1)
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star"></i>           
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i> 
                                    @endif
                                    @if($rating == 2)
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star" style="color: #ec4445;"></i>           
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i> 
                                    @endif  
                                    @if($rating == 3)
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star" style="color: #ec4445;"></i>           
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star"></i>
                                    <i class="fa fa-star"></i> 
                                    @endif  
                                    @if($rating == 4)
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star" style="color: #ec4445;"></i>           
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star"></i> 
                                    @endif  
                                    @if($rating == 5)
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star" style="color: #ec4445;"></i>           
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star" style="color: #ec4445;"></i>
                                    <i class="fa fa-star" style="color: #ec4445;"></i> @endif   
                                </div>
                                <div class="price-box">
                                    <span class="new-price"> Rs {{$new_product->selling_price}}</span>
                                    <span class="old-price">Rs {{$new_product->mrp_price}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                    <!-- single-product end --> 
                </div>              
            </div>
        </div>
    </div>
    <!-- new-product-area end -->
    
    <!-- top-sells-area start -->
    <div class="top-sells-area">
        <div class="container">
            <!-- section-heading start -->
            <div class="row">
                <div class="col-md-12">
                    <div class="section-heading">
                        <h3>Top Sellers</h3>
                    </div>
                </div>
            </div>
            <!-- section-heading end -->        
            <div class="row">
                <div class="top-sells-curosel">
                    <!-- single-product start -->
                    @foreach($top_sellers as $top_seller)
					@php
                                
                                    foreach($brands as $brand)
                                    {   

                                        $bid=$top_seller->brand_id;
                                        if($brand->id==$bid)
                                        {
                                          $bn=$brand->name;
                                          break;
                                        }

                                    }

                                    @endphp
                    <div class="col-12">
                        <div class="single-product first-sells">
                            <div class="product-img">
                                <a href="{{url('/p')}}/{{$top_seller->slug}}">
                                    <img class="primary-image" src="{{ asset('public/uploads/images') }}/{{@$top_seller->productImage->image}}" alt="{{$top_seller->name}}" />
                                    <img class="secondary-image" src="{{ asset('public/uploads/images') }}/{{@$top_seller->productImage->image}}" alt="{{$top_seller->name}}" />
                                </a>                        
                            </div>
                            <div class="product-content">
                                <div class="pro-info">
                                    <h2 class="product-name">
                                    <a href="{{url('/p')}}/{{$top_seller->slug}}">{{$top_seller->name}} - {{$top_seller->quantity}}</a><p class="text-info">{{$bn}}</p></h2>
                                    <?php $rating = \App\Http\Controllers\WelcomeController::getProductReview($product->id); ?>
                                    <div class="pro-rating"> 
                                        @if($rating == 0)
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i>           
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i> 
                                        @endif
                                        @if($rating == 1)
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star"></i>           
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i> 
                                        @endif
                                        @if($rating == 2)
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star" style="color: #ec4445;"></i>           
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i> 
                                        @endif  
                                        @if($rating == 3)
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star" style="color: #ec4445;"></i>           
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star"></i>
                                        <i class="fa fa-star"></i> 
                                        @endif  
                                        @if($rating == 4)
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star" style="color: #ec4445;"></i>           
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star"></i> 
                                        @endif  
                                        @if($rating == 5)
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star" style="color: #ec4445;"></i>           
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star" style="color: #ec4445;"></i>
                                        <i class="fa fa-star" style="color: #ec4445;"></i> @endif   
                                    </div>
                                    <div class="price-box">
                                        <span class="new-price">Rs {{$top_seller->selling_price}}</span>
                                        <span class="old-price">Rs {{$top_seller->mrp_price}}</span>
                                    </div>                              
                                </div>
                                <div class="actions">
                                    <div class="action-buttons">
                                        <div class="add-to-cart">
                                            @if($top_seller->stock_quantity > 1)
                                            <a onclick="addToCart(<?php echo $top_seller->id; ?>)" href="javascript:void(0)">Add to cart</a>
                                            @else
                                            <a href="javascript:void(0)">Out of Stock</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>                                  
                            </div>
                        </div>
                    </div>
                    @endforeach
                    <!-- single-product end -->
                </div>
            </div>
        </div>
    </div>
    <!-- top-sells-area end -->

    <div class="brand-area">
        <div class="container">
            <!-- section-heading start -->
            <div class="row">
                <div class="col-md-12">
                    <div class="section-heading">
                        <h3>Our Brands</h3>
                    </div>
                </div>
            </div>
            <!-- section-heading end -->        
            <div class="row">
                <div class="brand-curosel">
                  @foreach($brands as $brand)
                    <!-- single-brand start -->
                    <div class="col-12">
                        <div class="single-brand">
                            <a href="{{ url('brand') }}/{{$brand->slug}}"><img src="{{ url('/') }}/public/uploads/images/{{$brand->image}}" alt="" /></a>
                        </div>
                    </div>
                    <!-- single-brand end -->
                  @endforeach
                </div>
            </div>
        </div>
    </div>
    <!-- brand-area end -->
@endsection

   