@extends('layouts.app')

@section('content')
<!-- my-account-area start -->
  <div class="my-account-area">
    <div class="container" style="padding-top: 100px;">
      <div class="row">
        <div class="col-md-3"></div>
        <div class="col-md-6">
          <form method="POST" action="{{ route('password.update') }}">
            @csrf
            <input type="hidden" name="token" value="{{ $token }}">
            <div class="form-fields">
              <h2>Reset Password</h2>
              <p>
                <label>Email<span class="required">*</span></label>
                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus readonly="">

                @error('email')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
              </p>
              <p>   
                  <label>Passwords <span>*</span></label>
                  <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="current-password">

                  @error('password')
                      <span class="invalid-feedback" role="alert">
                          <strong>{{ $message }}</strong>
                      </span>
                  @enderror
               </p> 
               <p>   
                  <label>Confirm Password <span>*</span></label>
                  <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password_confirmation" required autocomplete="current-password">
               </p>   
            </div>
            

            <div class="form-action">
              <button type="submit" class="btn btn-dark">Send Password Reset Link</button>              
            </div>
          </form>
        </div>
        <div class="col-md-3"></div>
      </div>
    </div>
  </div>
  <!-- my-account-area end -->
@endsection