<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Recent extends Model
{
    protected $table="recents";
    protected $fillable=[
        'session_id','user_id','product_id','quantity','coupon_id','pincode_id'
    ];
    public function product()
    {
        return $this->belongsTo('App\Models\Product');
    }
    public function color()
    {
        return $this->belongsTo('App\Models\Color');
    }
    public function size()
    {
        return $this->belongsTo('App\Models\Size');
    }
}
