<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table="categories";
    protected $fillable=[
       'name','parent_id','slug','status','image'
    ];
    public function sub_categories()
    {
        return $this->hasMany('App\Models\Category','parent_id')->wherenotNull('parent_id');
    }

    public function products()
    {
        return $this->hasMany('App\Models\Product');
    }
}