<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Helpers\Helper;
use App\Models\Wallet;
use App\Models\Order;
use App\Models\Bank;
use App\Trading;
use App\Stacking;
use App\User;
use Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $withdraw = Order::where('user_id',Auth::user()->id)->where('type','0')->sum('amount');
        $sponser = Trading::where('user_id',Auth::user()->id)->where('type','SPONSER')->sum('total');
        $level = Trading::where('user_id',Auth::user()->id)->where('type','LEVEL')->first();

        $trade = Trading::where('user_id',Auth::user()->id)->where('type','TOPUP')->sum('total');
        $stack = Stacking::where('user_id',Auth::user()->id)->where('type','TOPUP')->sum('total');
        return view('home',compact('sponser','trade','stack','withdraw','level'));
    }

    public function ajax_call()
    {
        $level = -1;
        $referals = User::where('parent',Auth::user()->username)->get();
        foreach($referals as $referal)
        {
            $last = Order::where('user_id',$referal->id)->where('type','1')->first();
            if($last)
                $level++;
        }

        if($level == -1)
            $level = 0;
        else
            $level = ($level/10) + 1;

        if($level > 10)
            $level = 10;

        if($level != Auth::user()->level)
        {
            $user = User::find(Auth::user()->id);
            $user->level = $level;
            $user->save();

            $level_row = Trading::where('user_id',Auth::user()->id)->where('type','LEVEL')->first();
            $level_row->from_id = $level;
            $level_row->save();

            echo 1;
        }
    }

    public function plans()
    {
        if(Auth::user()->product_id)
            return redirect('wallet');

        $plans = Product::where('status','Active')->orderBy('bonus')->get();
        return view('plans',compact('plans'));
    }

    public function select_plan(Request $request)
    {
        if(Auth::user()->product_id)
            return redirect('wallet');
        
        $user = User::find(Auth::user()->id);
        $user->product_id = $request->id;
        $user->save();
        return redirect('wallet');
    }

    public function add_to_wallet(Request $request)
    {
        $last = Order::where('user_id',Auth::user()->id)->where('type','1')->first();

        $wallet = new Order;
        $wallet->txn_id = $request->txhash;
        $wallet->amount = $request->amount;
        $wallet->user_id = Auth::user()->id;
        $wallet->product_id = $request->product_id;
        $wallet->type = '1';
        $wallet->status = 'completed';
        $wallet->save();

        if(!$last)
        {
        $trade = new Trading;
        $trade->order_id = $wallet->id;
        $trade->amount = $request->amount*0.1;
        $trade->total = $trade->amount;
        $trade->user_id = Auth::user()->refer->id;
        $trade->from_id = Auth::user()->id;
        $trade->credit = 1;
        $trade->type = 'SPONSER';
        $trade->save();
        }

        $last = new Trading;
        $last->order_id = $wallet->id;
        $last->user_id = Auth::user()->id;
        $last->amount = $request->amount/2;
        $last->total = $last->amount;
        $last->type = 'TOPUP';
        $last->credit = 1;
        $last->save();

        $level = Trading::where('user_id',Auth::user()->id)->where('type','LEVEL')->first();
        $level->amount = $level->amount + $last->amount;
        $level->order_id = $level->order_id + $request->amount;
        $level->save();

        $last = new Stacking;
        $last->order_id = $wallet->id;
        $last->user_id = Auth::user()->id;
        $last->amount = $request->amount/2;
        $last->total = $last->amount;
        $last->type = 'TOPUP';
        $last->credit = 1;
        $last->save();

        $last->plan_date = date('Y-m-d',strtotime($last->created_at .' + '.($last->order->product->months*30).'days'));
        $last->save();

        echo 1;
        //return back()->with('flash_success','Amount added to wallet');
    }

    public function setting()
    {
        return view('setting');
    }

    public function setting_update(Request $request)
    {
        $bank = Bank::find($request->id);
        $bank->bank = $request->bank;
        $bank->account = $request->account;
        $bank->ifsc = $request->ifsc;
        $bank->other = $request->other;
        $bank->save();
        return back()->with('flash_success','Bank Account updated');
    }

    public function transaction()
    {
        $data = Order::where('user_id',Auth::user()->id)->where('type','1')->orderBy('id','DESC')->get();
        return view('transaction',compact('data'));
    }

    public function trading()
    {
        $data = Trading::where('user_id',Auth::user()->id)->orderBy('id','DESC')->get();
        return view('trading',compact('data'));
    }

    public function stacking()
    {
        $data = Stacking::where('user_id',Auth::user()->id)->orderBy('id','DESC')->get();
        return view('stacking',compact('data'));
    }

    public function stacking_mature()
    {
        $data = Wallet::where('user_id',Auth::user()->id)->orderBy('id','DESC')->get();
        return view('stacking-mature',compact('data'));
    }

    public function wallet()
    {
        $plans = Product::where('status','Active')->orderBy('bonus')->get();
        $data = Order::where('user_id',Auth::user()->id)->orderBy('id','DESC')->get();
        $trade = Trading::where('user_id',Auth::user()->id)->where('type','TOPUP')->sum('total');
        $sponser = Trading::where('user_id',Auth::user()->id)->where('type','SPONSER')->sum('total');
        $stack = Stacking::where('user_id',Auth::user()->id)->where('type','TOPUP')->sum('total');
        $level = Trading::where('user_id',Auth::user()->id)->where('type','LEVEL')->value('total');
        
        return view('wallet',compact('data','plans','trade','sponser','stack','level'));
    }

    public function wallet_withdraw(Request $request)
    {
        if($request->amount > $request->total)
            return back()->with('flash_success','Amount should not be more than Balance');

        $wallet = new Order;
        $wallet->txn_id = 'WITHDRAW';
        $wallet->amount = $request->amount;
        $wallet->user_id = Auth::user()->id;
        $wallet->product_id = 1;
        $wallet->type = '0';
        $wallet->status = 'pending';
        $wallet->save();
        return back()->with('flash_success','Withdraw request placed successfully');
    }

    public function change_password()
    {
        return view('user.change-password');
    }
    public function site_setting()
    {
        $data = SiteDetail::where('user_id', Auth::user()->id)->first();
        return view('user.site-setting', compact('data'));
    }
    public function site_setting_save(Request $request)
    {
        $data = SiteDetail::where('user_id', Auth::user()->id)->first();
        if($data){
        //    $slug = Helper::getBlogUrl($request->name);
        //     if (SiteDetail::where('url', '=', $slug)->where('id', '!=', $data->id)->count() > 0)
        // {
        //     $slug = $slug. time();
        // }
            $data->name = $request->name;
            $data->title = $request->title;
            $data->email = $request->email;
            $data->phone = $request->phone;
            $data->address = $request->address;
            $data->keyword = $request->keyword;
            $data->description = $request->description;
            $data->description = $request->description;
            //$data->url = $slug;
        }
        else{
            $slug = Helper::getBlogUrl($request->name);
            if (SiteDetail::where('url', '=', $slug)->count() > 0)
        {
            $slug = $slug. time();
        }
            $data = new SiteDetail;
            $data->name = $request->name;
            $data->title = $request->title;
            $data->email = $request->email;
            $data->phone = $request->phone;
            $data->address = $request->address;
            $data->keyword = $request->keyword;
            $data->description = $request->description;
            $data->user_id = Auth::user()->id;
            $data->url = $slug;
        }
        $data->save();
        return back()->with('flash_success', 'Data updated');
    }
    public function website_setting()
    {
        $data = SiteDetail::where('user_id', Auth::user()->id)->first();
        return view('user.website-setting', compact('data'));
    }
    public function website_setting_save(Request $request)
    {
        $data = SiteDetail::where('user_id', Auth::user()->id)->first();
        if($request->hasfile('favicon'))
        {
            @unlink('public/uploads/images/'.$data->image);
            $file = $request->file('favicon');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->image = $filename;  
        }

        if($request->hasfile('image1'))
        {
            @unlink('public/uploads/images/'.$data->image1);
            $file = $request->file('image1');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->image1 = $filename;  
        }

        if($request->hasfile('image2'))
        {
            @unlink('public/uploads/images/'.$data->image2);
            $file = $request->file('image2');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->image2 = $filename;  
        }

        if($request->hasfile('image3'))
        {
            @unlink('public/uploads/images/'.$data->image3);
            $file = $request->file('image3');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->image3 = $filename;
        }
        $data->banner = $request->banner;

        if($request->hasfile('about_image'))
        {
            @unlink('public/uploads/images/'.$data->about_banner);
            $file = $request->file('about_image');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->about_banner = $filename;
        }
        $data->about = $request->about;

        if($request->hasfile('why_image'))
        {
            @unlink('public/uploads/images/'.$data->why_banner);
            $file = $request->file('why_image');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->why_banner = $filename;
        }
        $data->why = $request->why;

        if($request->hasfile('contact_image'))
        {
            @unlink('public/uploads/images/'.$data->contact_banner);
            $file = $request->file('contact_image');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->contact_banner = $filename;
        }
        $data->contact = $request->contact;
        $data->map = $request->map;
        $data->footer = $request->footer;
        $data->save();
        return back()->with('flash_success', 'Data updated');
    }
    public function product_save(Request $request)
    {
        $data = SiteDetail::where('user_id', Auth::user()->id)->first();
        if($request->hasfile('product1'))
        {
            @unlink('public/uploads/images/'.$data->product1);
            $file = $request->file('product1');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->product1 = $filename;  
        }
        if($request->hasfile('product2'))
        {
            @unlink('public/uploads/images/'.$data->product2);
            $file = $request->file('product2');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->product2 = $filename;  
        }
        if($request->hasfile('product3'))
        {
            @unlink('public/uploads/images/'.$data->product3);
            $file = $request->file('product3');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->product3 = $filename;  
        }
        if($request->hasfile('product4'))
        {
            @unlink('public/uploads/images/'.$data->product4);
            $file = $request->file('product4');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->product4 = $filename;  
        }
        if($request->hasfile('product5'))
        {
            @unlink('public/uploads/images/'.$data->product5);
            $file = $request->file('product5');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->product5 = $filename;  
        }
        if($request->hasfile('product6'))
        {
            @unlink('public/uploads/images/'.$data->product6);
            $file = $request->file('product6');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $data->product6 = $filename;  
        }
        $data->save();
        return back()->with('flash_success', 'Data updated');
    }
    public function social_media_setting()
    {
        return view('user.social-media-setting');
    }
    public function whatsapp_setting()
    {
        return view('user.whatsapp-setting');
    }
    public function create_domainname()
    {
        $data = SiteDetail::where('user_id', Auth::user()->id)->first();
        return view('user.create-domainname', compact('data'));
    }
    public function create_domainname_save(Request $request)
    {
        $data = SiteDetail::where('user_id', Auth::user()->id)->first();
        $slug = Helper::getBlogUrl($request->url);
            if (SiteDetail::where('url', '=', $slug)->where('id', '!=', $data->id)->count() > 0)
        {
            $slug = $slug. time();
        }
        $data->url = $slug;
        $data->save();
        return back()->with('flash_success', 'Data updated');
    }
    public function create_logo()
    {
        return view('user.create-logo');
    }
    public function create_logo_save(Request $request)
    {
        $data = SiteDetail::where('user_id', Auth::user()->id)->first();
        $slug = Helper::getBlogUrl($request->url);
            if (SiteDetail::where('url', '=', $slug)->where('id', '!=', $data->id)->count() > 0)
        {
            $slug = $slug. time();
        }
        $data->url = $slug;
        $data->save();
        return back()->with('flash_success', 'Data updated');
    }
    public function account_settings()
    {
        return view('user.account-setting');
    }
    public function my_account()
    {
        return view('user.myprofile');
    }
}