<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Category;
use App\Helpers\Helper;
use App\Models\Wallet;
use App\Models\Order;

class WalletController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Wallet::where('remark','Pending')->orderBy('id','DESC')->paginate(20);
        return view('admin.orders.maturity',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        return view('admin.products.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'productstatus' => 'required',
        ]);

        $slug = Helper::getBlogUrl($request->productname);
        $product = new Product;
        $product->name = $request->productname;
        $product->status = $request->productstatus;
        $product->slug = $slug;
        $product->months = $request->months;
        $product->bonus = $request->bonus;
        $product->save();
            
        return redirect('admin/products')->with('flash_success', 'Plan Created Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    public function edit(Request $request,$id)
    {
        $data = Wallet::find($id);
        $data->remark = 'Completed';
        $data->save();
        return back()->with('flash_success', 'Approved Successfully');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'productstatus' => 'required',
        ]);

        $product = Product::find($id);
        $slug = Helper::getBlogUrl($request->productname);
        $product->name = $request->productname;
        $product->status = $request->productstatus;
        $product->slug = $slug;
        $product->months = $request->months;
        $product->bonus = $request->bonus;
        $product->save();
        return redirect('admin/products')->with('flash_success', 'Plan Updated Successfully');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Product::find($id);
        $data->delete();
        return back()->with('flash_success', 'Plan Deleted Successfully');
    }
}