<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Models\Category;
use App\Helpers\Helper;
use App\Models\Brand;
use App\Models\Order;
use App\Trading;
use App\Stacking;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Order::where('type','1')->orderBy('id','DESC')->paginate(20);
        return view('admin.orders.index',compact('data'));
    }

    public function withdraw(Request $request)
    {
        $data = Order::where('type','0')->where('status','Pending')->orderBy('id','DESC')->paginate(20);
        return view('admin.orders.withdraw',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        return view('admin.products.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'productstatus' => 'required',
        ]);

        $slug = Helper::getBlogUrl($request->productname);
        $product = new Product;
        $product->name = $request->productname;
        $product->status = $request->productstatus;
        $product->slug = $slug;
        $product->months = $request->months;
        $product->bonus = $request->bonus;
        $product->save();
            
        return redirect('admin/products')->with('flash_success', 'Plan Created Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    public function edit(Request $request,$id)
    {
        $data = Order::find($id);
        $data->status = 'Completed';
        $data->save();

        $trading = Trading::where('user_id',$data->user_id)->where('type', 'TOPUP')->orderBy('id','DESC')->get();

        $amount = $data->amount;
        foreach($trading as $trade)
        {
            if($amount <= $trade->total)
            {
                $trade->total = $trade->total - $amount;
                $trade->amount = $trade->total;
                $trade->save();
                $amount = 0;

                if($trade->amount == 0)
                    $trade->delete();

                break;
            }
            else
            {
                $amount = $amount - $trade->total;
                $trade->delete();
            }
        }

        $level = Trading::where('user_id',$data->user_id)->where('type','LEVEL')->first();
        if($amount>0)
        {
            if($amount <= $level->total)
            {
                $level->total = $level->total - $amount;
                $amount = 0;
            }
            else
            {
                $level->total = 0;
                $amount = $amount - $level->total;
            }
        }
        $trade_amount = Trading::where('user_id',$data->user_id)->where('type', 'TOPUP')->value('amount');
        $level->amount = $trade_amount ? $trade_amount : 0;
        $level->save();

        if($amount>0)
        {
            $sponsers = Trading::where('user_id',$data->user_id)->where('type','SPONSER')->get();
            foreach($sponsers as $sponser)
            {
                if($amount <= $sponser->total)
                {
                $sponser->total = $sponser->total - $amount;
                //$sponser->amount = $sponser->total;
                $sponser->save();
                $amount = 0;

                // if($sponser->total == 0)
                //     $sponser->delete();

                break;
                }
                else
                {
                $amount = $amount - $sponser->total;
                $sponser->total = 0;
                //$sponser->amount = $sponser->total;
                $sponser->save();
                //$sponser->delete();
                }
            }
        }

        $last = new Trading;
        $last->order_id = $data->id;
        $last->user_id = $data->user_id;
        $last->amount = $data->amount/4;
        $last->total = $last->amount;
        $last->type = 'TOPUP';
        $last->credit = 1;
        $last->save();

        $level = Trading::where('user_id',$last->user_id)->where('type','LEVEL')->first();
        $level->amount = $level->amount + $last->amount;
        //$level->order_id = $level->order_id + $data->amount;
        $level->save();

        $last_id = Stacking::where('user_id',$data->user_id)->where('type','TOPUP')->first();

        $last = new Stacking;
        $last->order_id = $data->id;
        $last->user_id = $data->user_id;
        $last->amount = $data->amount/4;
        $last->total = $last->amount;
        $last->plan_date = $last_id->plan_date;
        $last->type = 'TOPUP';
        $last->credit = 1;
        $last->save();
        return back()->with('flash_success', 'Approved Successfully');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'productstatus' => 'required',
        ]);

        $product = Product::find($id); 
        $slug = Helper::getBlogUrl($request->productname);
        $product->name = $request->productname;
        $product->status = $request->productstatus;
        $product->slug = $slug;
        $product->months = $request->months;
        $product->bonus = $request->bonus;
        $product->save();
        return redirect('admin/products')->with('flash_success', 'Plan Updated Successfully');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Product::find($id);
        $data->delete();
        return back()->with('flash_success', 'Plan Deleted Successfully');
    }
}