<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Trading;
use App\Stacking;
use App\Models\Order;
use App\Models\Wallet;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        // 
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();
        $schedule->call(function () {
            $lasts = Trading::where('type','TOPUP')->get();
            foreach($lasts as $last)
            {
                $last->total = $last->total + ($last->amount*0.005);
                $last->save();
            }

            $lasts = Trading::where('type','LEVEL')->where('from_id','>',0)->where('order_id','>=',100)->get();
            foreach($lasts as $last)
            {
                if($last->order_id >= ($last->from_id*100))
                {
                    $interest = $last->amount*0.005;
                    $interest = ($last->from_id < 6 || $last->from_id == 10) ? $interest*0.1 : $interest*0.05;
                    $last->total = $last->total + $interest;
                    $last->save();
                }
            }

            $lasts = Stacking::where('type','TOPUP')->get();
            $date_now = date('Y-m-d');
            foreach($lasts as $last)
            {
                if($last->plan_date > $date_now)
                {
                    $last->total = $last->total + ($last->amount*0.01);
                    $last->save();
                }
                else
                {
                    $wallet = new Wallet;
                    $wallet->remark = 'Pending';
                    $wallet->amount = $last->amount;
                    $wallet->bonus = $last->order->product->bonus;
                    $wallet->total = $last->total + ($wallet->amount*$wallet->bonus/100);
                    $wallet->user_id = $last->user_id;
                    $wallet->from_date = date('Y-m-d',strtotime($last->created_at));
                    $wallet->to_date = $last->plan_date;
                    $wallet->debit_credit_type = '1';
                    $wallet->save();
                    $last->delete();
                }
            }
        })->everyMinute();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
